//
//	Class definition for Prize message assembler class
//

#ifndef THE_PRIZE_MSG_ASSEMBLER_H
#define THE_PRIZE_MSG_ASSEMBLER_H

#include "../Game/theGameState.h"
#include "../Utils/theStringManager.h"
#include "ldwImage.h"
#include "ldwGameWindow.h"


class thePrizeMsgAssembler 
{
public:
	static thePrizeMsgAssembler * Get();
	static void Destroy();
	thePrizeMsgAssembler();
	~thePrizeMsgAssembler();
	char *CompileTechPrize(char *destString, int polarity, int amt);
	char *CompileFoodPrize(char *destString, int polarity, int amt);
	char *CompileMiscPrize(char *destString, int polarity, int amt, char* prizeString);
	char *PrepareString(char *destString, char *sourceString, char *nameString, int gender);
	char *PrepareStringImpl(char* destString, char *sourceString, char *nameString, int gender);

private:

	bool choiceMade;

	int size;
	int eventSelect;
	int choiceSelected;
	int yStart;

	void CompilePrizeMsg (char *destString, int polarity, char* prizeType, int amt);
	theGameState * gs;
	theStringManager *strMgr;
	ldwGameWindow *gameWindow;

	
protected:

	static thePrizeMsgAssembler *mInstance;
	
};

#endif
